'use strict'

entityRegistry['module']['mosaic'] = {
    extendedInfo: {
        displayName: 'Mosaic',
        displayGroup: 'Post Processing',
    },
    init: (staticConfig) => {
        const {
        } = { ...staticConfig }
         return {}
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'cellSize', displayName: 'Cell Size', type: 'int', defaultValue: 4},
        { paramName: 'colorActive', displayName: 'Color Active', type: 'boolean', defaultValue: true},
        { paramName: 'brightnessActive', displayName: 'Brightness Active', type: 'boolean', defaultValue: true},
        { paramName: 'depthActive', displayName: 'Depth Active', type: 'boolean', defaultValue: true},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                cellSize,
                colorActive,
                brightnessActive,
                depthActive,
            } = { ...config }

            const doMosaic = (bufferName) => {
                const srcBufferId = renderer.getCurrentBufferId(bufferName)
                const dstBufferId = renderer.lockBuffer(bufferName)
                const srcBuffer = renderer.getBufferFromId(bufferName, srcBufferId)
                const dstBuffer = renderer.getBufferFromId(bufferName, dstBufferId)
                const srcBufferData = srcBuffer.data
                const dstBufferData = dstBuffer.data
                const bufferWidth = srcBuffer.width
                const bufferHeight = srcBuffer.height

                for (let y = 0; y < bufferHeight; ++y) {
                    const sy = Math.floor(y / cellSize) * cellSize
                    for (let x = 0; x < bufferWidth; ++x) {
                        const sx = Math.floor(x / cellSize) * cellSize
                        dstBufferData[ x + y * bufferWidth] = srcBufferData[sx + sy * bufferWidth]
                    }
                }
            
                renderer.unlockBuffer(bufferName, srcBufferId)
                renderer.setCurrentBufferId(bufferName, dstBufferId)
            }

            if (colorActive) doMosaic('color')
            if (depthActive) doMosaic('depth')
            if (brightnessActive) doMosaic('brightness')
        }
    }
}
